"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, account_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Describes all of the budget actions for an account.

    Args:
        account_id(str): The account ID of the user. It should be a 12-digit number.
        max_results(int, optional):  An integer that represents how many entries a paginated response contains. The maximum is 100. Defaults to None.
        next_token(str, optional):  A generic string. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.action.for_.account.describe(
                ctx, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.action.for_.account.describe account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="describe_budget_actions_for_account",
        op_kwargs={
            "AccountId": account_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
