"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, client_token: str, quantum_task_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the specified task.

    Args:
        client_token(str): The client token associated with the request.
        quantum_task_arn(str): The ARN of the task to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.braket.quantum_task.cancel(
                ctx, client_token=value, quantum_task_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.braket.quantum_task.cancel client_token=value, quantum_task_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="braket",
        operation="cancel_quantum_task",
        op_kwargs={"clientToken": client_token, "quantumTaskArn": quantum_task_arn},
    )


async def create(
    hub,
    ctx,
    action: str,
    client_token: str,
    device_arn: str,
    output_s3_bucket: str,
    output_s3_key_prefix: str,
    shots: int,
    device_parameters: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a quantum task.

    Args:
        action(str): The action associated with the task.
        client_token(str): The client token associated with the request.
        device_arn(str): The ARN of the device to run the task on.
        device_parameters(str, optional): The parameters for the device to run the task on. Defaults to None.
        output_s3_bucket(str): The S3 bucket to store task result files in.
        output_s3_key_prefix(str): The key prefix for the location in the S3 bucket to store task results in.
        shots(int): The number of shots to use for the task.
        tags(Dict, optional): Tags to be added to the quantum task you're creating. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.braket.quantum_task.create(
                ctx,
                action=value,
                client_token=value,
                device_arn=value,
                output_s3_bucket=value,
                output_s3_key_prefix=value,
                shots=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.braket.quantum_task.create action=value, client_token=value, device_arn=value, output_s3_bucket=value, output_s3_key_prefix=value, shots=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="braket",
        operation="create_quantum_task",
        op_kwargs={
            "action": action,
            "clientToken": client_token,
            "deviceArn": device_arn,
            "deviceParameters": device_parameters,
            "outputS3Bucket": output_s3_bucket,
            "outputS3KeyPrefix": output_s3_key_prefix,
            "shots": shots,
            "tags": tags,
        },
    )


async def get(hub, ctx, quantum_task_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the specified quantum task.

    Args:
        quantum_task_arn(str): the ARN of the task to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.braket.quantum_task.get(ctx, quantum_task_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.braket.quantum_task.get quantum_task_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="braket",
        operation="get_quantum_task",
        op_kwargs={"quantumTaskArn": quantum_task_arn},
    )


async def search(
    hub, ctx, filters: List, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for tasks that match the specified filter values.

    Args:
        filters(List): Array of SearchQuantumTasksFilter objects.
        max_results(int, optional): Maximum number of results to return in the response. Defaults to None.
        next_token(str, optional): A token used for pagination of results returned in the response. Use the token returned from the previous request continue results where the previous request ended. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.braket.quantum_task.search(ctx, filters=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.braket.quantum_task.search filters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="braket",
        operation="search_quantum_tasks",
        op_kwargs={
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
