"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, device_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the devices available in Amazon Braket.

    Args:
        device_arn(str): The ARN of the device to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.braket.device.get(ctx, device_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.braket.device.get device_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="braket",
        operation="get_device",
        op_kwargs={"deviceArn": device_arn},
    )


async def search(
    hub, ctx, filters: List, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for devices using the specified filters.

    Args:
        filters(List): The filter values to use to search for a device.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        next_token(str, optional): A token used for pagination of results returned in the response. Use the token returned from the previous request continue results where the previous request ended. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.braket.device.search(ctx, filters=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.braket.device.search filters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="braket",
        operation="search_devices",
        op_kwargs={
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
