"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    job_queue_name: str,
    priority: int,
    compute_environment_order: List,
    state: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Batch job queue. When you create a job queue, you associate one or more compute environments to the queue and assign an order of preference for the compute environments. You also set a priority to the job queue that determines the order that the Batch scheduler places jobs onto its associated compute environments. For example, if a compute environment is associated with more than one job queue, the job queue with a higher priority is given preference for scheduling jobs to that compute environment.

    Args:
        job_queue_name(str): The name of the job queue. Up to 128 letters (uppercase and lowercase), numbers, and underscores are allowed.
        state(str, optional): The state of the job queue. If the job queue state is ENABLED, it is able to accept jobs. If the job queue state is DISABLED, new jobs can't be added to the queue, but jobs already in the queue can finish. Defaults to None.
        priority(int): The priority of the job queue. Job queues with a higher priority (or a higher integer value for the priority parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order. For example, a job queue with a priority value of 10 is given scheduling preference over a job queue with a priority value of 1. All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT); EC2 and Fargate compute environments can't be mixed.
        compute_environment_order(List): The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment should run a specific job. Compute environments must be in the VALID state before you can associate them with a job queue. You can associate up to three compute environments with a job queue. All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT); EC2 and Fargate compute environments can't be mixed.  All compute environments that are associated with a job queue must share the same architecture. Batch doesn't support mixing compute environment architecture types in a single job queue. .
        tags(Dict, optional): The tags that you apply to the job queue to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see Tagging your Batch resources in Batch User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.batch.job.queue.create(
                ctx, job_queue_name=value, priority=value, compute_environment_order=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.batch.job.queue.create job_queue_name=value, priority=value, compute_environment_order=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="batch",
        operation="create_job_queue",
        op_kwargs={
            "jobQueueName": job_queue_name,
            "state": state,
            "priority": priority,
            "computeEnvironmentOrder": compute_environment_order,
            "tags": tags,
        },
    )


async def delete(hub, ctx, job_queue: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified job queue. You must first disable submissions for a queue with the UpdateJobQueue operation. All jobs in the queue are eventually terminated when you delete a job queue. The jobs are terminated at a rate of about 16 jobs each second. It's not necessary to disassociate compute environments from a queue before submitting a DeleteJobQueue request.

    Args:
        job_queue(str): The short name or full Amazon Resource Name (ARN) of the queue to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.batch.job.queue.delete(ctx, job_queue=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.batch.job.queue.delete job_queue=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="batch",
        operation="delete_job_queue",
        op_kwargs={"jobQueue": job_queue},
    )


async def describe_all(
    hub, ctx, job_queues: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your job queues.

    Args:
        job_queues(List, optional): A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries. Defaults to None.
        max_results(int, optional): The maximum number of results returned by DescribeJobQueues in paginated output. When this parameter is used, DescribeJobQueues only returns maxResults results in a single page and a nextToken response element. The remaining results of the initial request can be seen by sending another DescribeJobQueues request with the returned nextToken value. This value can be between 1 and 100. If this parameter isn't used, then DescribeJobQueues returns up to 100 results and a nextToken value if applicable. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated DescribeJobQueues request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. This value is null when there are no more results to return.  This token should be treated as an opaque identifier that's only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.batch.job.queue.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.batch.job.queue.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="batch",
        operation="describe_job_queues",
        op_kwargs={
            "jobQueues": job_queues,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    job_queue: str,
    state: str = None,
    priority: int = None,
    compute_environment_order: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a job queue.

    Args:
        job_queue(str): The name or the Amazon Resource Name (ARN) of the job queue.
        state(str, optional): Describes the queue's ability to accept new jobs. If the job queue state is ENABLED, it can accept jobs. If the job queue state is DISABLED, new jobs can't be added to the queue, but jobs already in the queue can finish. Defaults to None.
        priority(int, optional): The priority of the job queue. Job queues with a higher priority (or a higher integer value for the priority parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order, for example, a job queue with a priority value of 10 is given scheduling preference over a job queue with a priority value of 1. All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT). EC2 and Fargate compute environments can't be mixed. Defaults to None.
        compute_environment_order(List, optional): Details the set of compute environments mapped to a job queue and their order relative to each other. This is one of the parameters used by the job scheduler to determine which compute environment should run a given job. Compute environments must be in the VALID state before you can associate them with a job queue. All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT). EC2 and Fargate compute environments can't be mixed.  All compute environments that are associated with a job queue must share the same architecture. Batch doesn't support mixing compute environment architecture types in a single job queue. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.batch.job.queue.update(ctx, job_queue=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.batch.job.queue.update job_queue=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="batch",
        operation="update_job_queue",
        op_kwargs={
            "jobQueue": job_queue,
            "state": state,
            "priority": priority,
            "computeEnvironmentOrder": compute_environment_order,
        },
    )
