"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, job_id: str, reason: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a job in an Batch job queue. Jobs that are in the SUBMITTED, PENDING, or RUNNABLE state are canceled. Jobs that have progressed to STARTING or RUNNING aren't canceled, but the API operation still succeeds, even if no job is canceled. These jobs must be terminated with the TerminateJob operation.

    Args:
        job_id(str): The Batch job ID of the job to cancel.
        reason(str): A message to attach to the job that explains the reason for canceling it. This message is returned by future DescribeJobs operations on the job. This message is also recorded in the Batch activity logs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.batch.job.init.cancel(ctx, job_id=value, reason=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.batch.job.init.cancel job_id=value, reason=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="batch",
        operation="cancel_job",
        op_kwargs={"jobId": job_id, "reason": reason},
    )


async def submit(
    hub,
    ctx,
    job_name: str,
    job_queue: str,
    job_definition: str,
    array_properties: Dict = None,
    depends_on: List = None,
    parameters: Dict = None,
    container_overrides: Dict = None,
    node_overrides: Dict = None,
    retry_strategy: Dict = None,
    propagate_tags: bool = None,
    timeout: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Submits an Batch job from a job definition. Parameters that are specified during SubmitJob override parameters defined in the job definition. vCPU and memory requirements that are specified in the ResourceRequirements objects in the job definition are the exception. They can't be overridden this way using the memory and vcpus parameters. Rather, you must specify updates to job definition parameters in a ResourceRequirements object that's included in the containerOverrides parameter.  Jobs that run on Fargate resources can't be guaranteed to run for more than 14 days. This is because, after 14 days, Fargate resources might become unavailable and job might be terminated.

    Args:
        job_name(str): The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
        job_queue(str): The job queue where the job is submitted. You can specify either the name or the Amazon Resource Name (ARN) of the queue.
        array_properties(Dict, optional): The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. For more information, see Array Jobs in the Batch User Guide. Defaults to None.
        depends_on(List, optional): A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Defaults to None.
        job_definition(str): The job definition used by this job. This value can be one of name, name:revision, or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.
        parameters(Dict, optional): Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters in a SubmitJob request override any corresponding parameter defaults from the job definition. Defaults to None.
        container_overrides(Dict, optional): A list of container overrides in the JSON format that specify the name of a container in the specified job definition and the overrides it should receive. You can override the default command for a container, which is specified in the job definition or the Docker image, with a command override. You can also override existing environment variables on a container or add new environment variables to it with an environment override. Defaults to None.
        node_overrides(Dict, optional): A list of node overrides in JSON format that specify the node range to target and the container overrides for that node range.  This parameter isn't applicable to jobs that are running on Fargate resources; use containerOverrides instead. . Defaults to None.
        retry_strategy(Dict, optional): The retry strategy to use for failed jobs from this SubmitJob operation. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition. Defaults to None.
        propagate_tags(bool, optional): Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks during task creation. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the FAILED state. When specified, this overrides the tag propagation setting in the job definition. Defaults to None.
        timeout(Dict, optional): The timeout configuration for this SubmitJob operation. You can specify a timeout duration after which Batch terminates your jobs if they haven't finished. If a job is terminated due to a timeout, it isn't retried. The minimum value for the timeout is 60 seconds. This configuration overrides any timeout configuration specified in the job definition. For array jobs, child jobs have the same timeout configuration as the parent job. For more information, see Job Timeouts in the Amazon Elastic Container Service Developer Guide. Defaults to None.
        tags(Dict, optional): The tags that you apply to the job request to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see Tagging Amazon Web Services Resources in Amazon Web Services General Reference. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.batch.job.init.submit(
                ctx, job_name=value, job_queue=value, job_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.batch.job.init.submit job_name=value, job_queue=value, job_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="batch",
        operation="submit_job",
        op_kwargs={
            "jobName": job_name,
            "jobQueue": job_queue,
            "arrayProperties": array_properties,
            "dependsOn": depends_on,
            "jobDefinition": job_definition,
            "parameters": parameters,
            "containerOverrides": container_overrides,
            "nodeOverrides": node_overrides,
            "retryStrategy": retry_strategy,
            "propagateTags": propagate_tags,
            "timeout": timeout,
            "tags": tags,
        },
    )


async def terminate(hub, ctx, job_id: str, reason: str) -> Dict:
    r"""
    **Autogenerated function**

    Terminates a job in a job queue. Jobs that are in the STARTING or RUNNING state are terminated, which causes them to transition to FAILED. Jobs that have not progressed to the STARTING state are cancelled.

    Args:
        job_id(str): The Batch job ID of the job to terminate.
        reason(str): A message to attach to the job that explains the reason for canceling it. This message is returned by future DescribeJobs operations on the job. This message is also recorded in the Batch activity logs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.batch.job.init.terminate(ctx, job_id=value, reason=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.batch.job.init.terminate job_id=value, reason=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="batch",
        operation="terminate_job",
        op_kwargs={"jobId": job_id, "reason": reason},
    )
