"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(hub, ctx, job_definition: str) -> Dict:
    r"""
    **Autogenerated function**

    Deregisters an Batch job definition. Job definitions are permanently deleted after 180 days.

    Args:
        job_definition(str): The name and revision (name:revision) or full Amazon Resource Name (ARN) of the job definition to deregister.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.batch.job.definition.deregister(ctx, job_definition=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.batch.job.definition.deregister job_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="batch",
        operation="deregister_job_definition",
        op_kwargs={"jobDefinition": job_definition},
    )


async def describe_all(
    hub,
    ctx,
    job_definitions: List = None,
    max_results: int = None,
    job_definition_name: str = None,
    status: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes a list of job definitions. You can specify a status (such as ACTIVE) to only return job definitions that match that status.

    Args:
        job_definitions(List, optional): A list of up to 100 job definitions. Each entry in the list can either be an ARN of the form arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision} or a short version using the form ${JobDefinitionName}:${Revision}. Defaults to None.
        max_results(int, optional): The maximum number of results returned by DescribeJobDefinitions in paginated output. When this parameter is used, DescribeJobDefinitions only returns maxResults results in a single page and a nextToken response element. The remaining results of the initial request can be seen by sending another DescribeJobDefinitions request with the returned nextToken value. This value can be between 1 and 100. If this parameter isn't used, then DescribeJobDefinitions returns up to 100 results and a nextToken value if applicable. Defaults to None.
        job_definition_name(str, optional): The name of the job definition to describe. Defaults to None.
        status(str, optional): The status used to filter job definitions. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated DescribeJobDefinitions request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. This value is null when there are no more results to return.  This token should be treated as an opaque identifier that's only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.batch.job.definition.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.batch.job.definition.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="batch",
        operation="describe_job_definitions",
        op_kwargs={
            "jobDefinitions": job_definitions,
            "maxResults": max_results,
            "jobDefinitionName": job_definition_name,
            "status": status,
            "nextToken": next_token,
        },
    )


async def register(
    hub,
    ctx,
    job_definition_name: str,
    type_: str,
    parameters: Dict = None,
    container_properties: Dict = None,
    node_properties: Dict = None,
    retry_strategy: Dict = None,
    propagate_tags: bool = None,
    timeout: Dict = None,
    tags: Dict = None,
    platform_capabilities: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers an Batch job definition.

    Args:
        job_definition_name(str): The name of the job definition to register. Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
        type_(str): The type of job definition. For more information about multi-node parallel jobs, see Creating a multi-node parallel job definition in the Batch User Guide.  If the job is run on Fargate resources, then multinode isn't supported. .
        parameters(Dict, optional): Default parameter substitution placeholders to set in the job definition. Parameters are specified as a key-value pair mapping. Parameters in a SubmitJob request override any corresponding parameter defaults from the job definition. Defaults to None.
        container_properties(Dict, optional): An object with various properties specific to single-node container-based jobs. If the job definition's type parameter is container, then you must specify either containerProperties or nodeProperties.  If the job runs on Fargate resources, then you must not specify nodeProperties; use only containerProperties. . Defaults to None.
        node_properties(Dict, optional): An object with various properties specific to multi-node parallel jobs. If you specify node properties for a job, it becomes a multi-node parallel job. For more information, see Multi-node Parallel Jobs in the Batch User Guide. If the job definition's type parameter is container, then you must specify either containerProperties or nodeProperties.  If the job runs on Fargate resources, then you must not specify nodeProperties; use containerProperties instead. . Defaults to None.
        retry_strategy(Dict, optional): The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy that's specified during a SubmitJob operation overrides the retry strategy defined here. If a job is terminated due to a timeout, it isn't retried. Defaults to None.
        propagate_tags(bool, optional): Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags are not propagated. Tags can only be propagated to the tasks during task creation. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the FAILED state. Defaults to None.
        timeout(Dict, optional): The timeout configuration for jobs that are submitted with this job definition, after which Batch terminates your jobs if they have not finished. If a job is terminated due to a timeout, it isn't retried. The minimum value for the timeout is 60 seconds. Any timeout configuration that's specified during a SubmitJob operation overrides the timeout configuration defined here. For more information, see Job Timeouts in the Batch User Guide. Defaults to None.
        tags(Dict, optional): The tags that you apply to the job definition to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see Tagging Amazon Web Services Resources in Batch User Guide. Defaults to None.
        platform_capabilities(List, optional): The platform capabilities required by the job definition. If no value is specified, it defaults to EC2. To run the job on Fargate resources, specify FARGATE. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.batch.job.definition.register(
                ctx, job_definition_name=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.batch.job.definition.register job_definition_name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="batch",
        operation="register_job_definition",
        op_kwargs={
            "jobDefinitionName": job_definition_name,
            "type": type_,
            "parameters": parameters,
            "containerProperties": container_properties,
            "nodeProperties": node_properties,
            "retryStrategy": retry_strategy,
            "propagateTags": propagate_tags,
            "timeout": timeout,
            "tags": tags,
            "platformCapabilities": platform_capabilities,
        },
    )
