"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "supported_resource_type"


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the AWS resource types supported by AWS Backup.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.supported_resource_type_.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.supported_resource_type.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="get_supported_resource_types",
        op_kwargs={},
    )
