"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: Dict) -> None:
    r"""
    **Autogenerated function**

    Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN).

    Args:
        resource_arn(str): An ARN that uniquely identifies a resource. The format of the ARN depends on the type of the tagged resource.
        tags(Dict): Key-value pairs that are used to help organize your resources. You can assign your own metadata to the resources you create.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.resource.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_key_list: List) -> None:
    r"""
    **Autogenerated function**

    Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN)

    Args:
        resource_arn(str): An ARN that uniquely identifies a resource. The format of the ARN depends on the type of the tagged resource.
        tag_key_list(List): A list of keys to identify which key-value tags to remove from a resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.resource.untag(
                ctx, resource_arn=value, tag_key_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.resource.untag resource_arn=value, tag_key_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeyList": tag_key_list},
    )
