"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the current service opt-in settings for the Region. If service-opt-in is enabled for a service, AWS Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, AWS Backup does not try to protect that service's resources in this Region, AWS Backup does not try to protect that service's resources in this Region.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.region_setting.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.region_setting.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="backup", operation="describe_region_settings", op_kwargs={}
    )


async def update_multiple(
    hub, ctx, resource_type_opt_in_preference: Dict = None
) -> None:
    r"""
    **Autogenerated function**

    Updates the current service opt-in settings for the Region. If service-opt-in is enabled for a service, AWS Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, AWS Backup does not try to protect that service's resources in this Region. Use the DescribeRegionSettings API to determine the resource types that are supported.

    Args:
        resource_type_opt_in_preference(Dict, optional): Updates the list of services along with the opt-in preferences for the Region. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.region_setting.update_multiple(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.region_setting.update_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="update_region_settings",
        op_kwargs={"ResourceTypeOptInPreference": resource_type_opt_in_preference},
    )
