"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, backup_vault_name: str, recovery_point_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a set of metadata key-value pairs that were used to create the backup.

    Args:
        backup_vault_name(str): The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of lowercase letters, numbers, and hyphens.
        recovery_point_arn(str): An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.recovery_point.restore_metadata.get(
                ctx, backup_vault_name=value, recovery_point_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.recovery_point.restore_metadata.get backup_vault_name=value, recovery_point_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="get_recovery_point_restore_metadata",
        op_kwargs={
            "BackupVaultName": backup_vault_name,
            "RecoveryPointArn": recovery_point_arn,
        },
    )
