"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name (ARN), and the AWS service type of the saved resource.

    Args:
        resource_arn(str): An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.protected_resource.describe(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.protected_resource.describe resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="describe_protected_resource",
        op_kwargs={"ResourceArn": resource_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of resources successfully backed up by AWS Backup, including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.

    Args:
        next_token(str, optional): The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. Defaults to None.
        max_results(int, optional): The maximum number of items to be returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.protected_resource.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.protected_resource.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="list_protected_resources",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
