"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Describes the global settings of the AWS account, including whether it is opted in to cross-account backup.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.global_setting.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.global_setting.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="backup", operation="describe_global_settings", op_kwargs={}
    )


async def update_multiple(hub, ctx, global_settings: Dict = None) -> None:
    r"""
    **Autogenerated function**

    Updates the current global settings for the AWS account. Use the DescribeGlobalSettings API to determine the current settings.

    Args:
        global_settings(Dict, optional): A list of resources along with the opt-in preferences for the account. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.global_setting.update_multiple(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.global_setting.update_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="update_global_settings",
        op_kwargs={"GlobalSettings": global_settings},
    )
