"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, copy_job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata associated with creating a copy of a resource.

    Args:
        copy_job_id(str): Uniquely identifies a copy job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.copy_job.describe(ctx, copy_job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.copy_job.describe copy_job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="describe_copy_job",
        op_kwargs={"CopyJobId": copy_job_id},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    by_resource_arn: str = None,
    by_state: str = None,
    by_created_before: str = None,
    by_created_after: str = None,
    by_resource_type: str = None,
    by_destination_vault_arn: str = None,
    by_account_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata about your copy jobs.

    Args:
        next_token(str, optional): The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. . Defaults to None.
        max_results(int, optional): The maximum number of items to be returned. Defaults to None.
        by_resource_arn(str, optional): Returns only copy jobs that match the specified resource Amazon Resource Name (ARN). . Defaults to None.
        by_state(str, optional): Returns only copy jobs that are in the specified state. Defaults to None.
        by_created_before(str, optional): Returns only copy jobs that were created before the specified date. Defaults to None.
        by_created_after(str, optional): Returns only copy jobs that were created after the specified date. Defaults to None.
        by_resource_type(str, optional): Returns only backup jobs for the specified resources:    DynamoDB for Amazon DynamoDB    EBS for Amazon Elastic Block Store    EC2 for Amazon Elastic Compute Cloud    EFS for Amazon Elastic File System    RDS for Amazon Relational Database Service    Aurora for Amazon Aurora    Storage Gateway for AWS Storage Gateway  . Defaults to None.
        by_destination_vault_arn(str, optional): An Amazon Resource Name (ARN) that uniquely identifies a source backup vault to copy from; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault. . Defaults to None.
        by_account_id(str, optional): The account ID to list the jobs from. Returns only copy jobs associated with the specified account ID. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.copy_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.copy_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="list_copy_jobs",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "ByResourceArn": by_resource_arn,
            "ByState": by_state,
            "ByCreatedBefore": by_created_before,
            "ByCreatedAfter": by_created_after,
            "ByResourceType": by_resource_type,
            "ByDestinationVaultArn": by_destination_vault_arn,
            "ByAccountId": by_account_id,
        },
    )


async def start(
    hub,
    ctx,
    recovery_point_arn: str,
    source_backup_vault_name: str,
    destination_backup_vault_arn: str,
    iam_role_arn: str,
    idempotency_token: str = None,
    lifecycle: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a job to create a one-time copy of the specified resource. Does not support continuous backups.

    Args:
        recovery_point_arn(str): An ARN that uniquely identifies a recovery point to use for the copy job; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45. .
        source_backup_vault_name(str): The name of a logical source container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of lowercase letters, numbers, and hyphens.
        destination_backup_vault_arn(str): An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to copy to; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
        iam_role_arn(str): Specifies the IAM role ARN used to copy the target recovery point; for example, arn:aws:iam::123456789012:role/S3Access.
        idempotency_token(str, optional): A customer chosen string that can be used to distinguish between calls to StartCopyJob. Defaults to None.
        lifecycle(Dict, optional): Contains an array of Transition objects specifying how long in days before a recovery point transitions to cold storage or is deleted. Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, on the console, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. Only Amazon EFS file system backups can be transitioned to cold storage. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.copy_job.start(
                ctx,
                recovery_point_arn=value,
                source_backup_vault_name=value,
                destination_backup_vault_arn=value,
                iam_role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.copy_job.start recovery_point_arn=value, source_backup_vault_name=value, destination_backup_vault_arn=value, iam_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="start_copy_job",
        op_kwargs={
            "RecoveryPointArn": recovery_point_arn,
            "SourceBackupVaultName": source_backup_vault_name,
            "DestinationBackupVaultArn": destination_backup_vault_arn,
            "IamRoleArn": iam_role_arn,
            "IdempotencyToken": idempotency_token,
            "Lifecycle": lifecycle,
        },
    )
