"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(hub, ctx, backup_vault_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes event notifications for the specified backup vault.

    Args:
        backup_vault_name(str): The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.vault.notification.delete_multiple(
                ctx, backup_vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.vault.notification.delete_multiple backup_vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="delete_backup_vault_notifications",
        op_kwargs={"BackupVaultName": backup_vault_name},
    )


async def get_all(hub, ctx, backup_vault_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns event notifications for the specified backup vault.

    Args:
        backup_vault_name(str): The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of lowercase letters, numbers, and hyphens.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.vault.notification.get_all(
                ctx, backup_vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.vault.notification.get_all backup_vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="get_backup_vault_notifications",
        op_kwargs={"BackupVaultName": backup_vault_name},
    )


async def put_multiple(
    hub, ctx, backup_vault_name: str, sns_topic_arn: str, backup_vault_events: List
) -> None:
    r"""
    **Autogenerated function**

    Turns on notifications on a backup vault for the specified topic and events.

    Args:
        backup_vault_name(str): The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of lowercase letters, numbers, and hyphens.
        sns_topic_arn(str): The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for example, arn:aws:sns:us-west-2:111122223333:MyVaultTopic.
        backup_vault_events(List): An array of events that indicate the status of jobs to back up resources to the backup vault.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.vault.notification.put_multiple(
                ctx, backup_vault_name=value, sns_topic_arn=value, backup_vault_events=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.vault.notification.put_multiple backup_vault_name=value, sns_topic_arn=value, backup_vault_events=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="put_backup_vault_notifications",
        op_kwargs={
            "BackupVaultName": backup_vault_name,
            "SNSTopicArn": sns_topic_arn,
            "BackupVaultEvents": backup_vault_events,
        },
    )
