"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    backup_vault_name: str,
    backup_vault_tags: Dict = None,
    encryption_key_arn: str = None,
    creator_request_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a logical container where backups are stored. A CreateBackupVault request includes a name, optionally one or more resource tags, an encryption key, and a request ID.  Sensitive data, such as passport numbers, should not be included the name of a backup vault.

    Args:
        backup_vault_name(str): The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of letters, numbers, and hyphens.
        backup_vault_tags(Dict, optional): Metadata that you can assign to help organize the resources that you create. Each tag is a key-value pair. Defaults to None.
        encryption_key_arn(str, optional): The server-side encryption key that is used to protect your backups; for example, arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab. Defaults to None.
        creator_request_id(str, optional): A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.vault.init.create(ctx, backup_vault_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.vault.init.create backup_vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="create_backup_vault",
        op_kwargs={
            "BackupVaultName": backup_vault_name,
            "BackupVaultTags": backup_vault_tags,
            "EncryptionKeyArn": encryption_key_arn,
            "CreatorRequestId": creator_request_id,
        },
    )


async def delete(hub, ctx, backup_vault_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.

    Args:
        backup_vault_name(str): The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of lowercase letters, numbers, and hyphens.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.vault.init.delete(ctx, backup_vault_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.vault.init.delete backup_vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="delete_backup_vault",
        op_kwargs={"BackupVaultName": backup_vault_name},
    )


async def describe(hub, ctx, backup_vault_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata about a backup vault specified by its name.

    Args:
        backup_vault_name(str): The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of lowercase letters, numbers, and hyphens.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.vault.init.describe(ctx, backup_vault_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.vault.init.describe backup_vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="describe_backup_vault",
        op_kwargs={"BackupVaultName": backup_vault_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of recovery point storage containers along with information about them.

    Args:
        next_token(str, optional): The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. Defaults to None.
        max_results(int, optional): The maximum number of items to be returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.vault.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.vault.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="list_backup_vaults",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
