"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, backup_vault_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the policy document that manages permissions on a backup vault.

    Args:
        backup_vault_name(str): The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of lowercase letters, numbers, and hyphens.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.vault.access_policy.delete(
                ctx, backup_vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.vault.access_policy.delete backup_vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="delete_backup_vault_access_policy",
        op_kwargs={"BackupVaultName": backup_vault_name},
    )


async def get(hub, ctx, backup_vault_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the access policy document that is associated with the named backup vault.

    Args:
        backup_vault_name(str): The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of lowercase letters, numbers, and hyphens.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.vault.access_policy.get(
                ctx, backup_vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.vault.access_policy.get backup_vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="get_backup_vault_access_policy",
        op_kwargs={"BackupVaultName": backup_vault_name},
    )


async def put(hub, ctx, backup_vault_name: str, policy: str = None) -> None:
    r"""
    **Autogenerated function**

    Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a backup vault name and an access policy document in JSON format.

    Args:
        backup_vault_name(str): The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of lowercase letters, numbers, and hyphens.
        policy(str, optional): The backup vault access policy document in JSON format. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.vault.access_policy.put(
                ctx, backup_vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.vault.access_policy.put backup_vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="put_backup_vault_access_policy",
        op_kwargs={"BackupVaultName": backup_vault_name, "Policy": policy},
    )
