"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    backup_plan_id: str,
    backup_selection: Dict,
    creator_request_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a JSON document that specifies a set of resources to assign to a backup plan. Resources can be included by specifying patterns for a ListOfTags and selected Resources.  For example, consider the following patterns:    Resources: "arn:aws:ec2:region:account-id:volume/volume-id"     ConditionKey:"department"   ConditionValue:"finance"   ConditionType:"StringEquals"     ConditionKey:"importance"   ConditionValue:"critical"   ConditionType:"StringEquals"    Using these patterns would back up all Amazon Elastic Block Store (Amazon EBS) volumes that are tagged as "department=finance", "importance=critical", in addition to an EBS volume with the specified volume ID. Resources and conditions are additive in that all resources that match the pattern are selected. This shouldn't be confused with a logical AND, where all conditions must match. The matching patterns are logically put together using the OR operator. In other words, all patterns that match are selected for backup.

    Args:
        backup_plan_id(str): Uniquely identifies the backup plan to be associated with the selection of resources.
        backup_selection(Dict): Specifies the body of a request to assign a set of resources to a backup plan.
        creator_request_id(str, optional): A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.selection.create(
                ctx, backup_plan_id=value, backup_selection=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.selection.create backup_plan_id=value, backup_selection=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="create_backup_selection",
        op_kwargs={
            "BackupPlanId": backup_plan_id,
            "BackupSelection": backup_selection,
            "CreatorRequestId": creator_request_id,
        },
    )


async def delete(hub, ctx, backup_plan_id: str, selection_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the resource selection associated with a backup plan that is specified by the SelectionId.

    Args:
        backup_plan_id(str): Uniquely identifies a backup plan.
        selection_id(str): Uniquely identifies the body of a request to assign a set of resources to a backup plan.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.selection.delete(
                ctx, backup_plan_id=value, selection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.selection.delete backup_plan_id=value, selection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="delete_backup_selection",
        op_kwargs={"BackupPlanId": backup_plan_id, "SelectionId": selection_id},
    )


async def get(hub, ctx, backup_plan_id: str, selection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns selection metadata and a document in JSON format that specifies a list of resources that are associated with a backup plan.

    Args:
        backup_plan_id(str): Uniquely identifies a backup plan.
        selection_id(str): Uniquely identifies the body of a request to assign a set of resources to a backup plan.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.selection.get(
                ctx, backup_plan_id=value, selection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.selection.get backup_plan_id=value, selection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="get_backup_selection",
        op_kwargs={"BackupPlanId": backup_plan_id, "SelectionId": selection_id},
    )


async def list_all(
    hub, ctx, backup_plan_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array containing metadata of the resources associated with the target backup plan.

    Args:
        backup_plan_id(str): Uniquely identifies a backup plan.
        next_token(str, optional): The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. Defaults to None.
        max_results(int, optional): The maximum number of items to be returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.selection.list_all(ctx, backup_plan_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.selection.list_all backup_plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="list_backup_selections",
        op_kwargs={
            "BackupPlanId": backup_plan_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
