"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, backup_plan_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and version IDs.

    Args:
        backup_plan_id(str): Uniquely identifies a backup plan.
        next_token(str, optional): The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. Defaults to None.
        max_results(int, optional): The maximum number of items to be returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.plan.version.list_all(ctx, backup_plan_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.plan.version.list_all backup_plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="list_backup_plan_versions",
        op_kwargs={
            "BackupPlanId": backup_plan_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
