"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def export(hub, ctx, backup_plan_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the backup plan that is specified by the plan ID as a backup template.

    Args:
        backup_plan_id(str): Uniquely identifies a backup plan.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.plan.template.export(ctx, backup_plan_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.plan.template.export backup_plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="export_backup_plan_template",
        op_kwargs={"BackupPlanId": backup_plan_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and deletion dates.

    Args:
        next_token(str, optional): The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. Defaults to None.
        max_results(int, optional): The maximum number of items to be returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.plan.template.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.plan.template.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="list_backup_plan_templates",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
