"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    backup_plan: Dict,
    backup_plan_tags: Dict = None,
    creator_request_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains information that AWS Backup uses to schedule tasks that create recovery points for resources. If you call CreateBackupPlan with a plan that already exists, an AlreadyExistsException is returned.

    Args:
        backup_plan(Dict): Specifies the body of a backup plan. Includes a BackupPlanName and one or more sets of Rules.
        backup_plan_tags(Dict, optional): To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair. The specified tags are assigned to all backups created with this plan. Defaults to None.
        creator_request_id(str, optional): Identifies the request and allows failed requests to be retried without the risk of running the operation twice. If the request includes a CreatorRequestId that matches an existing backup plan, that plan is returned. This parameter is optional. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.plan.init.create(ctx, backup_plan=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.plan.init.create backup_plan=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="create_backup_plan",
        op_kwargs={
            "BackupPlan": backup_plan,
            "BackupPlanTags": backup_plan_tags,
            "CreatorRequestId": creator_request_id,
        },
    )


async def delete(hub, ctx, backup_plan_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will still exist.

    Args:
        backup_plan_id(str): Uniquely identifies a backup plan.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.plan.init.delete(ctx, backup_plan_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.plan.init.delete backup_plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="delete_backup_plan",
        op_kwargs={"BackupPlanId": backup_plan_id},
    )


async def get(hub, ctx, backup_plan_id: str, version_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns BackupPlan details for the specified BackupPlanId. The details are the body of a backup plan in JSON format, in addition to plan metadata.

    Args:
        backup_plan_id(str): Uniquely identifies a backup plan.
        version_id(str, optional): Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.plan.init.get(ctx, backup_plan_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.plan.init.get backup_plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="get_backup_plan",
        op_kwargs={"BackupPlanId": backup_plan_id, "VersionId": version_id},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    include_deleted: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of existing backup plans for an authenticated account. The list is populated only if the advanced option is set for the backup plan. The list contains information such as Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request IDs.

    Args:
        next_token(str, optional): The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. Defaults to None.
        max_results(int, optional): The maximum number of items to be returned. Defaults to None.
        include_deleted(bool, optional): A Boolean value with a default value of FALSE that returns deleted backup plans when set to TRUE. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.plan.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.plan.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="list_backup_plans",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "IncludeDeleted": include_deleted,
        },
    )


async def update(hub, ctx, backup_plan_id: str, backup_plan: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing backup plan identified by its backupPlanId with the input document in JSON format. The new version is uniquely identified by a VersionId.

    Args:
        backup_plan_id(str): Uniquely identifies a backup plan.
        backup_plan(Dict): Specifies the body of a backup plan. Includes a BackupPlanName and one or more sets of Rules.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.plan.init.update(
                ctx, backup_plan_id=value, backup_plan=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.plan.init.update backup_plan_id=value, backup_plan=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="update_backup_plan",
        op_kwargs={"BackupPlanId": backup_plan_id, "BackupPlan": backup_plan},
    )
