"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, backup_plan_template_json: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a valid JSON document specifying a backup plan or an error.

    Args:
        backup_plan_template_json(str): A customer-supplied backup plan document in JSON format.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.plan.from_.json.get(
                ctx, backup_plan_template_json=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.plan.from_.json.get backup_plan_template_json=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="get_backup_plan_from_json",
        op_kwargs={"BackupPlanTemplateJson": backup_plan_template_json},
    )
