"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, backup_job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns backup job details for the specified BackupJobId.

    Args:
        backup_job_id(str): Uniquely identifies a request to AWS Backup to back up a resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.job.describe(ctx, backup_job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.job.describe backup_job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="describe_backup_job",
        op_kwargs={"BackupJobId": backup_job_id},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    by_resource_arn: str = None,
    by_state: str = None,
    by_backup_vault_name: str = None,
    by_created_before: str = None,
    by_created_after: str = None,
    by_resource_type: str = None,
    by_account_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of time, consider using these monitoring tools.

    Args:
        next_token(str, optional): The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. Defaults to None.
        max_results(int, optional): The maximum number of items to be returned. Defaults to None.
        by_resource_arn(str, optional): Returns only backup jobs that match the specified resource Amazon Resource Name (ARN). Defaults to None.
        by_state(str, optional): Returns only backup jobs that are in the specified state. Defaults to None.
        by_backup_vault_name(str, optional): Returns only backup jobs that will be stored in the specified backup vault. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of lowercase letters, numbers, and hyphens. Defaults to None.
        by_created_before(str, optional): Returns only backup jobs that were created before the specified date. Defaults to None.
        by_created_after(str, optional): Returns only backup jobs that were created after the specified date. Defaults to None.
        by_resource_type(str, optional): Returns only backup jobs for the specified resources:    DynamoDB for Amazon DynamoDB    EBS for Amazon Elastic Block Store    EC2 for Amazon Elastic Compute Cloud    EFS for Amazon Elastic File System    RDS for Amazon Relational Database Service    Aurora for Amazon Aurora    Storage Gateway for AWS Storage Gateway  . Defaults to None.
        by_account_id(str, optional): The account ID to list the jobs from. Returns only backup jobs associated with the specified account ID. If used from an AWS Organizations management account, passing * returns all jobs across the organization. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="list_backup_jobs",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "ByResourceArn": by_resource_arn,
            "ByState": by_state,
            "ByBackupVaultName": by_backup_vault_name,
            "ByCreatedBefore": by_created_before,
            "ByCreatedAfter": by_created_after,
            "ByResourceType": by_resource_type,
            "ByAccountId": by_account_id,
        },
    )


async def start(
    hub,
    ctx,
    backup_vault_name: str,
    resource_arn: str,
    iam_role_arn: str,
    idempotency_token: str = None,
    start_window_minutes: int = None,
    complete_window_minutes: int = None,
    lifecycle: Dict = None,
    recovery_point_tags: Dict = None,
    backup_options: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an on-demand backup job for the specified resource.

    Args:
        backup_vault_name(str): The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of lowercase letters, numbers, and hyphens.
        resource_arn(str): An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
        iam_role_arn(str): Specifies the IAM role ARN used to create the target recovery point; for example, arn:aws:iam::123456789012:role/S3Access.
        idempotency_token(str, optional): A customer chosen string that can be used to distinguish between calls to StartBackupJob. Defaults to None.
        start_window_minutes(int, optional): A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully. This value is optional, and the default is 8 hours. Defaults to None.
        complete_window_minutes(int, optional): A value in minutes during which a successfully started backup must complete, or else AWS Backup will cancel the job. This value is optional. This value begins counting down from when the backup was scheduled. It does not add additional time for StartWindowMinutes, or if the backup started later than scheduled. Defaults to None.
        lifecycle(Dict, optional): The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup will transition and expire backups automatically according to the lifecycle that you define.  Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.  Only Amazon EFS file system backups can be transitioned to cold storage. Defaults to None.
        recovery_point_tags(Dict, optional): To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair. Defaults to None.
        backup_options(Dict, optional): Specifies the backup option for a selected resource. This option is only available for Windows VSS backup jobs. Valid values: Set to "WindowsVSS”:“enabled" to enable WindowsVSS backup option and create a VSS Windows backup. Set to “WindowsVSS”:”disabled” to create a regular backup. The WindowsVSS option is not enabled by default. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.job.start(
                ctx, backup_vault_name=value, resource_arn=value, iam_role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.job.start backup_vault_name=value, resource_arn=value, iam_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="start_backup_job",
        op_kwargs={
            "BackupVaultName": backup_vault_name,
            "ResourceArn": resource_arn,
            "IamRoleArn": iam_role_arn,
            "IdempotencyToken": idempotency_token,
            "StartWindowMinutes": start_window_minutes,
            "CompleteWindowMinutes": complete_window_minutes,
            "Lifecycle": lifecycle,
            "RecoveryPointTags": recovery_point_tags,
            "BackupOptions": backup_options,
        },
    )


async def stop(hub, ctx, backup_job_id: str) -> None:
    r"""
    **Autogenerated function**

    Attempts to cancel a job to create a one-time backup of a resource.

    Args:
        backup_job_id(str): Uniquely identifies a request to AWS Backup to back up a resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.backup.backup.job.stop(ctx, backup_job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.backup.backup.job.stop backup_job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="backup",
        operation="stop_backup_job",
        op_kwargs={"BackupJobId": backup_job_id},
    )
