"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    scaling_plan_name: str,
    scaling_plan_version: int,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the scalable resources in the specified scaling plan.

    Args:
        scaling_plan_name(str): The name of the scaling plan.
        scaling_plan_version(int): The version number of the scaling plan. Currently, the only valid value is 1.
        max_results(int, optional): The maximum number of scalable resources to return. The value must be between 1 and 50. The default value is 50. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling_plan_scaling_plan.resource.init.describe_all(
                ctx, scaling_plan_name=value, scaling_plan_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling_plan_scaling_plan.resource.init.describe_all scaling_plan_name=value, scaling_plan_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling-plans",
        operation="describe_scaling_plan_resources",
        op_kwargs={
            "ScalingPlanName": scaling_plan_name,
            "ScalingPlanVersion": scaling_plan_version,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
