"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    scaling_plan_name: str,
    scaling_plan_version: int,
    service_namespace: str,
    resource_id: str,
    scalable_dimension: str,
    forecast_data_type: str,
    start_time: str,
    end_time: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the forecast data for a scalable resource. Capacity forecasts are represented as predicted values, or data points, that are calculated using historical data points from a specified CloudWatch load metric. Data points are available for up to 56 days.

    Args:
        scaling_plan_name(str): The name of the scaling plan.
        scaling_plan_version(int): The version number of the scaling plan. Currently, the only valid value is 1.
        service_namespace(str): The namespace of the AWS service. The only valid value is autoscaling. .
        resource_id(str): The ID of the resource. This string consists of a prefix (autoScalingGroup) followed by the name of a specified Auto Scaling group (my-asg). Example: autoScalingGroup/my-asg. .
        scalable_dimension(str): The scalable dimension for the resource. The only valid value is autoscaling:autoScalingGroup:DesiredCapacity. .
        forecast_data_type(str): The type of forecast data to get.    LoadForecast: The load metric forecast.     CapacityForecast: The capacity forecast.     ScheduledActionMinCapacity: The minimum capacity for each scheduled scaling action. This data is calculated as the larger of two values: the capacity forecast or the minimum capacity in the scaling instruction.    ScheduledActionMaxCapacity: The maximum capacity for each scheduled scaling action. The calculation used is determined by the predictive scaling maximum capacity behavior setting in the scaling instruction.  .
        start_time(str): The inclusive start time of the time range for the forecast data to get. The date and time can be at most 56 days before the current date and time. .
        end_time(str): The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is seven days.  Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for periods of two days in advance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling_plan_scaling_plan.resource.forecast_data.get(
                ctx,
                scaling_plan_name=value,
                scaling_plan_version=value,
                service_namespace=value,
                resource_id=value,
                scalable_dimension=value,
                forecast_data_type=value,
                start_time=value,
                end_time=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling_plan_scaling_plan.resource.forecast_data.get scaling_plan_name=value, scaling_plan_version=value, service_namespace=value, resource_id=value, scalable_dimension=value, forecast_data_type=value, start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling-plans",
        operation="get_scaling_plan_resource_forecast_data",
        op_kwargs={
            "ScalingPlanName": scaling_plan_name,
            "ScalingPlanVersion": scaling_plan_version,
            "ServiceNamespace": service_namespace,
            "ResourceId": resource_id,
            "ScalableDimension": scalable_dimension,
            "ForecastDataType": forecast_data_type,
            "StartTime": start_time,
            "EndTime": end_time,
        },
    )
