"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    scaling_plan_name: str,
    application_source: Dict,
    scaling_instructions: List,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a scaling plan.

    Args:
        scaling_plan_name(str): The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
        application_source(Dict): A CloudFormation stack or set of tags. You can create one scaling plan per application source. For more information, see ApplicationSource in the AWS Auto Scaling API Reference.
        scaling_instructions(List): The scaling instructions. For more information, see ScalingInstruction in the AWS Auto Scaling API Reference.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling_plan_scaling_plan.init.create(
                ctx, scaling_plan_name=value, application_source=value, scaling_instructions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling_plan_scaling_plan.init.create scaling_plan_name=value, application_source=value, scaling_instructions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling-plans",
        operation="create_scaling_plan",
        op_kwargs={
            "ScalingPlanName": scaling_plan_name,
            "ApplicationSource": application_source,
            "ScalingInstructions": scaling_instructions,
        },
    )


async def delete(hub, ctx, scaling_plan_name: str, scaling_plan_version: int) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified scaling plan. Deleting a scaling plan deletes the underlying ScalingInstruction for all of the scalable resources that are covered by the plan. If the plan has launched resources or has scaling activities in progress, you must delete those resources separately.

    Args:
        scaling_plan_name(str): The name of the scaling plan.
        scaling_plan_version(int): The version number of the scaling plan. Currently, the only valid value is 1.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling_plan_scaling_plan.init.delete(
                ctx, scaling_plan_name=value, scaling_plan_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling_plan_scaling_plan.init.delete scaling_plan_name=value, scaling_plan_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling-plans",
        operation="delete_scaling_plan",
        op_kwargs={
            "ScalingPlanName": scaling_plan_name,
            "ScalingPlanVersion": scaling_plan_version,
        },
    )


async def describe_all(
    hub,
    ctx,
    scaling_plan_names: List = None,
    scaling_plan_version: int = None,
    application_sources: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your scaling plans.

    Args:
        scaling_plan_names(List, optional): The names of the scaling plans (up to 10). If you specify application sources, you cannot specify scaling plan names. Defaults to None.
        scaling_plan_version(int, optional): The version number of the scaling plan. Currently, the only valid value is 1.  If you specify a scaling plan version, you must also specify a scaling plan name. . Defaults to None.
        application_sources(List, optional): The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify application sources. Defaults to None.
        max_results(int, optional): The maximum number of scalable resources to return. This value can be between 1 and 50. The default value is 50. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling_plan_scaling_plan.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling_plan_scaling_plan.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling-plans",
        operation="describe_scaling_plans",
        op_kwargs={
            "ScalingPlanNames": scaling_plan_names,
            "ScalingPlanVersion": scaling_plan_version,
            "ApplicationSources": application_sources,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    scaling_plan_name: str,
    scaling_plan_version: int,
    application_source: Dict = None,
    scaling_instructions: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified scaling plan. You cannot update a scaling plan if it is in the process of being created, updated, or deleted.

    Args:
        scaling_plan_name(str): The name of the scaling plan.
        scaling_plan_version(int): The version number of the scaling plan. The only valid value is 1. Currently, you cannot have multiple scaling plan versions.
        application_source(Dict, optional): A CloudFormation stack or set of tags. For more information, see ApplicationSource in the AWS Auto Scaling API Reference. Defaults to None.
        scaling_instructions(List, optional): The scaling instructions. For more information, see ScalingInstruction in the AWS Auto Scaling API Reference. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling_plan_scaling_plan.init.update(
                ctx, scaling_plan_name=value, scaling_plan_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling_plan_scaling_plan.init.update scaling_plan_name=value, scaling_plan_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling-plans",
        operation="update_scaling_plan",
        op_kwargs={
            "ScalingPlanName": scaling_plan_name,
            "ScalingPlanVersion": scaling_plan_version,
            "ApplicationSource": application_source,
            "ScalingInstructions": scaling_instructions,
        },
    )
