"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(
    hub, ctx, auto_scaling_group_name: str, force_delete: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the warm pool for the specified Auto Scaling group. For more information, see Warm pools for Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        force_delete(bool, optional): Specifies that the warm pool is to be deleted along with all of its associated instances, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the warm pool instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.warm_pool.delete(ctx, auto_scaling_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.warm_pool.delete auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="delete_warm_pool",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "ForceDelete": force_delete,
        },
    )


async def describe(
    hub,
    ctx,
    auto_scaling_group_name: str,
    max_records: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a warm pool and its instances. For more information, see Warm pools for Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        max_records(int, optional): The maximum number of instances to return with this call. The maximum value is 50. Defaults to None.
        next_token(str, optional): The token for the next set of instances to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.warm_pool.describe(
                ctx, auto_scaling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.warm_pool.describe auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_warm_pool",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "MaxRecords": max_records,
            "NextToken": next_token,
        },
    )


async def put(
    hub,
    ctx,
    auto_scaling_group_name: str,
    max_group_prepared_capacity: int = None,
    min_size: int = None,
    pool_state: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a warm pool for the specified Auto Scaling group. A warm pool is a pool of pre-initialized EC2 instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto Scaling group can draw on the warm pool to meet its new desired capacity. For more information and example configurations, see Warm pools for Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide. This operation must be called from the Region in which the Auto Scaling group was created. This operation cannot be called on an Auto Scaling group that has a mixed instances policy or a launch template or launch configuration that requests Spot Instances. You can view the instances in the warm pool using the DescribeWarmPool API call. If you are no longer using a warm pool, you can delete it by calling the DeleteWarmPool API.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        max_group_prepared_capacity(int, optional): Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group. This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity.   If a value for MaxGroupPreparedCapacity is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for MaxGroupPreparedCapacity, Amazon EC2 Auto Scaling uses the difference between the MaxGroupPreparedCapacity and the desired capacity instead.  The size of the warm pool is dynamic. Only when MaxGroupPreparedCapacity and MinSize are set to the same value does the warm pool have an absolute size.  If the desired capacity of the Auto Scaling group is higher than the MaxGroupPreparedCapacity, the capacity of the warm pool is 0, unless you specify a value for MinSize. To remove a value that you previously set, include the property but specify -1 for the value. . Defaults to None.
        min_size(int, optional): Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified. Defaults to None.
        pool_state(str, optional): Sets the instance state to transition to after the lifecycle actions are complete. Default is Stopped. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.warm_pool.put(ctx, auto_scaling_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.warm_pool.put auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="put_warm_pool",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "MaxGroupPreparedCapacity": max_group_prepared_capacity,
            "MinSize": min_size,
            "PoolState": pool_state,
        },
    )
