"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "termination_policy_type"


async def describe_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Describes the termination policies supported by Amazon EC2 Auto Scaling. For more information, see Controlling which Auto Scaling instances terminate during scale in in the Amazon EC2 Auto Scaling User Guide.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.termination_policy_type_.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.termination_policy_type.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_termination_policy_types",
        op_kwargs={},
    )
