"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, tags: List) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified tags.

    Args:
        tags(List): One or more tags.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.tags.delete(ctx, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.tags.delete tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="delete_tags",
        op_kwargs={"Tags": tags},
    )


async def describe(
    hub, ctx, filters: List = None, next_token: str = None, max_records: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified tags. You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it to be included in the results. You can also specify multiple filters. The result includes information for a particular tag only if it matches all the filters. If there's no match, no special message is returned. For more information, see Tagging Auto Scaling groups and instances in the Amazon EC2 Auto Scaling User Guide.

    Args:
        filters(List, optional): One or more filters to scope the tags to return. The maximum number of filters per filter type (for example, auto-scaling-group) is 1000. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_records(int, optional): The maximum number of items to return with this call. The default value is 50 and the maximum value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.tags.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.tags.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_tags",
        op_kwargs={
            "Filters": filters,
            "NextToken": next_token,
            "MaxRecords": max_records,
        },
    )
