"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def put(
    hub,
    ctx,
    auto_scaling_group_name: str,
    scheduled_action_name: str,
    time: str = None,
    start_time: str = None,
    end_time: str = None,
    recurrence: str = None,
    min_size: int = None,
    max_size: int = None,
    desired_capacity: int = None,
    time_zone: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Creates or updates a scheduled scaling action for an Auto Scaling group. For more information, see Scheduled scaling in the Amazon EC2 Auto Scaling User Guide. You can view the scheduled actions for an Auto Scaling group using the DescribeScheduledActions API call. If you are no longer using a scheduled action, you can delete it by calling the DeleteScheduledAction API.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        scheduled_action_name(str): The name of this scaling action.
        time(str, optional): This parameter is no longer used. Defaults to None.
        start_time(str, optional): The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, "2019-06-01T00:00:00Z"). If you specify Recurrence and StartTime, Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence. If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message. Defaults to None.
        end_time(str, optional): The date and time for the recurring schedule to end, in UTC. Defaults to None.
        recurrence(str, optional): The recurring schedule for this action. This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, "30 0 1 1,6,12 *"). For more information about this format, see Crontab. When StartTime and EndTime are specified with Recurrence, they form the boundaries of when the recurring action starts and stops. Cron expressions use Universal Coordinated Time (UTC) by default. Defaults to None.
        min_size(int, optional): The minimum size of the Auto Scaling group. Defaults to None.
        max_size(int, optional): The maximum size of the Auto Scaling group. Defaults to None.
        desired_capacity(int, optional): The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. It can scale beyond this capacity if you add more scaling conditions. . Defaults to None.
        time_zone(str, optional): Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default.  Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as Etc/GMT+9 or Pacific/Tahiti). For more information, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.scheduled.update_group_action.put(
                ctx, auto_scaling_group_name=value, scheduled_action_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.scheduled.update_group_action.put auto_scaling_group_name=value, scheduled_action_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="put_scheduled_update_group_action",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "ScheduledActionName": scheduled_action_name,
            "Time": time,
            "StartTime": start_time,
            "EndTime": end_time,
            "Recurrence": recurrence,
            "MinSize": min_size,
            "MaxSize": max_size,
            "DesiredCapacity": desired_capacity,
            "TimeZone": time_zone,
        },
    )
