"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, auto_scaling_group_name: str, scheduled_action_name: str
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified scheduled action.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        scheduled_action_name(str): The name of the action to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.scheduled.action.delete(
                ctx, auto_scaling_group_name=value, scheduled_action_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.scheduled.action.delete auto_scaling_group_name=value, scheduled_action_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="delete_scheduled_action",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "ScheduledActionName": scheduled_action_name,
        },
    )


async def describe_all(
    hub,
    ctx,
    auto_scaling_group_name: str = None,
    scheduled_action_names: List = None,
    start_time: str = None,
    end_time: str = None,
    next_token: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the scheduled actions that haven't run or that have not reached their end time. To describe the scaling activities for scheduled actions that have already run, call the DescribeScalingActivities API.

    Args:
        auto_scaling_group_name(str, optional): The name of the Auto Scaling group. Defaults to None.
        scheduled_action_names(List, optional): The names of one or more scheduled actions. If you omit this parameter, all scheduled actions are described. If you specify an unknown scheduled action, it is ignored with no error. Array Members: Maximum number of 50 actions. Defaults to None.
        start_time(str, optional): The earliest scheduled start time to return. If scheduled action names are provided, this parameter is ignored. Defaults to None.
        end_time(str, optional): The latest scheduled start time to return. If scheduled action names are provided, this parameter is ignored. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_records(int, optional): The maximum number of items to return with this call. The default value is 50 and the maximum value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.scheduled.action.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.scheduled.action.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_scheduled_actions",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "ScheduledActionNames": scheduled_action_names,
            "StartTime": start_time,
            "EndTime": end_time,
            "NextToken": next_token,
            "MaxRecords": max_records,
        },
    )
