"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "process_type"


async def describe_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Describes the scaling process types for use with the ResumeProcesses and SuspendProcesses APIs.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.scaling.process_type_.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.scaling.process_type.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_scaling_process_types",
        op_kwargs={},
    )
