"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def put(
    hub,
    ctx,
    auto_scaling_group_name: str,
    policy_name: str,
    policy_type: str = None,
    adjustment_type: str = None,
    min_adjustment_step: int = None,
    min_adjustment_magnitude: int = None,
    scaling_adjustment: int = None,
    cooldown: int = None,
    metric_aggregation_type: str = None,
    step_adjustments: List = None,
    estimated_instance_warmup: int = None,
    target_tracking_configuration: Dict = None,
    enabled: bool = None,
    predictive_scaling_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a scaling policy for an Auto Scaling group. Scaling policies are used to scale an Auto Scaling group based on configurable metrics. If no policies are defined, the dynamic scaling and predictive scaling features are not used.  For more information about using dynamic scaling, see Target tracking scaling policies and Step and simple scaling policies in the Amazon EC2 Auto Scaling User Guide. For more information about using predictive scaling, see Predictive scaling for Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide. You can view the scaling policies for an Auto Scaling group using the DescribePolicies API call. If you are no longer using a scaling policy, you can delete it by calling the DeletePolicy API.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        policy_name(str): The name of the policy.
        policy_type(str, optional): One of the following policy types:     TargetTrackingScaling     StepScaling     SimpleScaling (default)    PredictiveScaling   . Defaults to None.
        adjustment_type(str, optional): Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid values are ChangeInCapacity, ExactCapacity, and PercentChangeInCapacity. Required if the policy type is StepScaling or SimpleScaling. For more information, see Scaling adjustment types in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        min_adjustment_step(int, optional): Available for backward compatibility. Use MinAdjustmentMagnitude instead. Defaults to None.
        min_adjustment_magnitude(int, optional): The minimum value to scale by when the adjustment type is PercentChangeInCapacity. For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a MinAdjustmentMagnitude of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a MinAdjustmentMagnitude of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances. Valid only if the policy type is StepScaling or SimpleScaling. For more information, see Scaling adjustment types in the Amazon EC2 Auto Scaling User Guide.  Some Auto Scaling groups use instance weights. In this case, set the MinAdjustmentMagnitude to a value that is at least as large as your largest instance weight. . Defaults to None.
        scaling_adjustment(int, optional): The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value. Required if the policy type is SimpleScaling. (Not used with any other policy type.) . Defaults to None.
        cooldown(int, optional): The duration of the policy's cooldown period, in seconds. When a cooldown period is specified here, it overrides the default cooldown period defined for the Auto Scaling group. Valid only if the policy type is SimpleScaling. For more information, see Scaling cooldowns for Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        metric_aggregation_type(str, optional): The aggregation type for the CloudWatch metrics. The valid values are Minimum, Maximum, and Average. If the aggregation type is null, the value is treated as Average. Valid only if the policy type is StepScaling. Defaults to None.
        step_adjustments(List, optional): A set of adjustments that enable you to scale based on the size of the alarm breach. Required if the policy type is StepScaling. (Not used with any other policy type.) . Defaults to None.
        estimated_instance_warmup(int, optional): The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. If not provided, the default is to use the value from the default cooldown period for the Auto Scaling group. Valid only if the policy type is TargetTrackingScaling or StepScaling. Defaults to None.
        target_tracking_configuration(Dict, optional): A target tracking scaling policy. Provides support for predefined or customized metrics. The following predefined metrics are available:    ASGAverageCPUUtilization     ASGAverageNetworkIn     ASGAverageNetworkOut     ALBRequestCountPerTarget    If you specify ALBRequestCountPerTarget for the metric, you must specify the ResourceLabel parameter with the PredefinedMetricSpecification. For more information, see TargetTrackingConfiguration in the Amazon EC2 Auto Scaling API Reference. Required if the policy type is TargetTrackingScaling. Defaults to None.
        enabled(bool, optional): Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more information, see Disabling a scaling policy for an Auto Scaling group in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        predictive_scaling_configuration(Dict, optional): A predictive scaling policy. Provides support for only predefined metrics. Predictive scaling works with CPU utilization, network in/out, and the Application Load Balancer request count. For more information, see PredictiveScalingConfiguration in the Amazon EC2 Auto Scaling API Reference. Required if the policy type is PredictiveScaling. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.scaling.policy.put(
                ctx, auto_scaling_group_name=value, policy_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.scaling.policy.put auto_scaling_group_name=value, policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="put_scaling_policy",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "PolicyName": policy_name,
            "PolicyType": policy_type,
            "AdjustmentType": adjustment_type,
            "MinAdjustmentStep": min_adjustment_step,
            "MinAdjustmentMagnitude": min_adjustment_magnitude,
            "ScalingAdjustment": scaling_adjustment,
            "Cooldown": cooldown,
            "MetricAggregationType": metric_aggregation_type,
            "StepAdjustments": step_adjustments,
            "EstimatedInstanceWarmup": estimated_instance_warmup,
            "TargetTrackingConfiguration": target_tracking_configuration,
            "Enabled": enabled,
            "PredictiveScalingConfiguration": predictive_scaling_configuration,
        },
    )
