"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    activity_ids: List = None,
    auto_scaling_group_name: str = None,
    include_deleted_groups: bool = None,
    max_records: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the scaling activities in the account and Region. When scaling events occur, you see a record of the scaling activity in the scaling activities. For more information, see Verifying a scaling activity for an Auto Scaling group in the Amazon EC2 Auto Scaling User Guide. If the scaling event succeeds, the value of the StatusCode element in the response is Successful. If an attempt to launch instances failed, the StatusCode value is Failed or Cancelled and the StatusMessage element in the response indicates the cause of the failure. For help interpreting the StatusMessage, see Troubleshooting Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide.

    Args:
        activity_ids(List, optional): The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the past six weeks are described. If unknown activities are requested, they are ignored with no error. If you specify an Auto Scaling group, the results are limited to that group. Array Members: Maximum number of 50 IDs. Defaults to None.
        auto_scaling_group_name(str, optional): The name of the Auto Scaling group. Defaults to None.
        include_deleted_groups(bool, optional): Indicates whether to include scaling activity from deleted Auto Scaling groups. Defaults to None.
        max_records(int, optional): The maximum number of items to return with this call. The default value is 100 and the maximum value is 100. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.scaling.activity.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.scaling.activity.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_scaling_activities",
        op_kwargs={
            "ActivityIds": activity_ids,
            "AutoScalingGroupName": auto_scaling_group_name,
            "IncludeDeletedGroups": include_deleted_groups,
            "MaxRecords": max_records,
            "NextToken": next_token,
        },
    )
