"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, auto_scaling_group_name: str, scheduled_update_group_actions: List
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates one or more scheduled scaling actions for an Auto Scaling group.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        scheduled_update_group_actions(List): One or more scheduled actions. The maximum number allowed is 50.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.put_scheduled_update_group_action.batch(
                ctx, auto_scaling_group_name=value, scheduled_update_group_actions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.put_scheduled_update_group_action.batch auto_scaling_group_name=value, scheduled_update_group_actions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="batch_put_scheduled_update_group_action",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "ScheduledUpdateGroupActions": scheduled_update_group_actions,
        },
    )
