"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def resume(
    hub, ctx, auto_scaling_group_name: str, scaling_processes: List = None
) -> None:
    r"""
    **Autogenerated function**

    Resumes the specified suspended auto scaling processes, or all suspended process, for the specified Auto Scaling group. For more information, see Suspending and resuming scaling processes in the Amazon EC2 Auto Scaling User Guide.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        scaling_processes(List, optional): One or more of the following processes:    Launch     Terminate     AddToLoadBalancer     AlarmNotification     AZRebalance     HealthCheck     InstanceRefresh     ReplaceUnhealthy     ScheduledActions    If you omit this parameter, all processes are specified. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.process.resume(ctx, auto_scaling_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.process.resume auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="resume_processes",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "ScalingProcesses": scaling_processes,
        },
    )


async def suspend(
    hub, ctx, auto_scaling_group_name: str, scaling_processes: List = None
) -> None:
    r"""
    **Autogenerated function**

    Suspends the specified auto scaling processes, or all processes, for the specified Auto Scaling group. If you suspend either the Launch or Terminate process types, it can prevent other process types from functioning properly. For more information, see Suspending and resuming scaling processes in the Amazon EC2 Auto Scaling User Guide. To resume processes that have been suspended, call the ResumeProcesses API.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        scaling_processes(List, optional): One or more of the following processes:    Launch     Terminate     AddToLoadBalancer     AlarmNotification     AZRebalance     HealthCheck     InstanceRefresh     ReplaceUnhealthy     ScheduledActions    If you omit this parameter, all processes are specified. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.process.suspend(ctx, auto_scaling_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.process.suspend auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="suspend_processes",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "ScalingProcesses": scaling_processes,
        },
    )
