"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    auto_scaling_group_name: str,
    policy_name: str,
    start_time: str,
    end_time: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the forecast data for a predictive scaling policy. Load forecasts are predictions of the hourly load values using historical load data from CloudWatch and an analysis of historical trends. Capacity forecasts are represented as predicted values for the minimum capacity that is needed on an hourly basis, based on the hourly load forecast. A minimum of 24 hours of data is required to create the initial forecasts. However, having a full 14 days of historical data results in more accurate forecasts. For more information, see Predictive scaling for Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        policy_name(str): The name of the policy.
        start_time(str): The inclusive start time of the time range for the forecast data to get. At most, the date and time can be one year before the current date and time.
        end_time(str): The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is 30 days.  Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. Amazon EC2 Auto Scaling only issues forecasts for periods of two days in advance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.predictive_scaling_forecast.get(
                ctx,
                auto_scaling_group_name=value,
                policy_name=value,
                start_time=value,
                end_time=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.predictive_scaling_forecast.get auto_scaling_group_name=value, policy_name=value, start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="get_predictive_scaling_forecast",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "PolicyName": policy_name,
            "StartTime": start_time,
            "EndTime": end_time,
        },
    )
