"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, policy_name: str, auto_scaling_group_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified scaling policy. Deleting either a step scaling policy or a simple scaling policy deletes the underlying alarm action, but does not delete the alarm, even if it no longer has an associated action. For more information, see Deleting a scaling policy in the Amazon EC2 Auto Scaling User Guide.

    Args:
        auto_scaling_group_name(str, optional): The name of the Auto Scaling group. Defaults to None.
        policy_name(str): The name or Amazon Resource Name (ARN) of the policy.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.policy.delete(ctx, policy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.policy.delete policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="delete_policy",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "PolicyName": policy_name,
        },
    )


async def describe_all(
    hub,
    ctx,
    auto_scaling_group_name: str = None,
    policy_names: List = None,
    policy_types: List = None,
    next_token: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the scaling policies in the account and Region.

    Args:
        auto_scaling_group_name(str, optional): The name of the Auto Scaling group. Defaults to None.
        policy_names(List, optional): The names of one or more policies. If you omit this parameter, all policies are described. If a group name is provided, the results are limited to that group. If you specify an unknown policy name, it is ignored with no error. Array Members: Maximum number of 50 items. Defaults to None.
        policy_types(List, optional): One or more policy types. The valid values are SimpleScaling, StepScaling, TargetTrackingScaling, and PredictiveScaling. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_records(int, optional): The maximum number of items to be returned with each call. The default value is 50 and the maximum value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.policy.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.policy.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_policies",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "PolicyNames": policy_names,
            "PolicyTypes": policy_types,
            "NextToken": next_token,
            "MaxRecords": max_records,
        },
    )


async def execute(
    hub,
    ctx,
    policy_name: str,
    auto_scaling_group_name: str = None,
    honor_cooldown: bool = None,
    metric_value: float = None,
    breach_threshold: float = None,
) -> None:
    r"""
    **Autogenerated function**

    Executes the specified policy. This can be useful for testing the design of your scaling policy.

    Args:
        auto_scaling_group_name(str, optional): The name of the Auto Scaling group. Defaults to None.
        policy_name(str): The name or ARN of the policy.
        honor_cooldown(bool, optional): Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing the policy. Valid only if the policy type is SimpleScaling. For more information, see Scaling cooldowns for Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        metric_value(float, optional): The metric value to compare to BreachThreshold. This enables you to execute a policy of type StepScaling and determine which step adjustment to use. For example, if the breach threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric value to 59. If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns an error. Required if the policy type is StepScaling and not supported otherwise. Defaults to None.
        breach_threshold(float, optional): The breach threshold for the alarm. Required if the policy type is StepScaling and not supported otherwise. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.policy.execute(ctx, policy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.policy.execute policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="execute_policy",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "PolicyName": policy_name,
            "HonorCooldown": honor_cooldown,
            "MetricValue": metric_value,
            "BreachThreshold": breach_threshold,
        },
    )
