"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def create_multiple(hub, ctx, tags: List) -> None:
    r"""
    **Autogenerated function**

    Creates or updates tags for the specified Auto Scaling group. When you specify a tag with a key that already exists, the operation overwrites the previous tag definition, and you do not get an error message. For more information, see Tagging Auto Scaling groups and instances in the Amazon EC2 Auto Scaling User Guide.

    Args:
        tags(List): One or more tags.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.or_update_tag.create_multiple(ctx, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.or_update_tag.create_multiple tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="create_or_update_tags",
        op_kwargs={"Tags": tags},
    )
