"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, auto_scaling_group_name: str, topic_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified notification.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        topic_arn(str): The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS) topic.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.notification_configuration.delete(
                ctx, auto_scaling_group_name=value, topic_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.notification_configuration.delete auto_scaling_group_name=value, topic_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="delete_notification_configuration",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "TopicARN": topic_arn,
        },
    )


async def describe_all(
    hub,
    ctx,
    auto_scaling_group_names: List = None,
    next_token: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups.

    Args:
        auto_scaling_group_names(List, optional): The name of the Auto Scaling group. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_records(int, optional): The maximum number of items to return with this call. The default value is 50 and the maximum value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.notification_configuration.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.notification_configuration.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_notification_configurations",
        op_kwargs={
            "AutoScalingGroupNames": auto_scaling_group_names,
            "NextToken": next_token,
            "MaxRecords": max_records,
        },
    )


async def put(
    hub, ctx, auto_scaling_group_name: str, topic_arn: str, notification_types: List
) -> None:
    r"""
    **Autogenerated function**

    Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the specified topic can have messages delivered to an endpoint such as a web server or an email address. This configuration overwrites any existing configuration. For more information, see Getting Amazon SNS notifications when your Auto Scaling group scales in the Amazon EC2 Auto Scaling User Guide. If you exceed your maximum limit of SNS topics, which is 10 per Auto Scaling group, the call fails.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        topic_arn(str): The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS) topic.
        notification_types(List): The type of event that causes the notification to be sent. To query the notification types supported by Amazon EC2 Auto Scaling, call the DescribeAutoScalingNotificationTypes API.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.notification_configuration.put(
                ctx, auto_scaling_group_name=value, topic_arn=value, notification_types=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.notification_configuration.put auto_scaling_group_name=value, topic_arn=value, notification_types=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="put_notification_configuration",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "TopicARN": topic_arn,
            "NotificationTypes": notification_types,
        },
    )
