"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def disable(hub, ctx, auto_scaling_group_name: str, metrics: List = None) -> None:
    r"""
    **Autogenerated function**

    Disables group metrics for the specified Auto Scaling group.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        metrics(List, optional): Specifies one or more of the following metrics:    GroupMinSize     GroupMaxSize     GroupDesiredCapacity     GroupInServiceInstances     GroupPendingInstances     GroupStandbyInstances     GroupTerminatingInstances     GroupTotalInstances     GroupInServiceCapacity     GroupPendingCapacity     GroupStandbyCapacity     GroupTerminatingCapacity     GroupTotalCapacity     WarmPoolDesiredCapacity     WarmPoolWarmedCapacity     WarmPoolPendingCapacity     WarmPoolTerminatingCapacity     WarmPoolTotalCapacity     GroupAndWarmPoolDesiredCapacity     GroupAndWarmPoolTotalCapacity    If you omit this parameter, all metrics are disabled. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.metric_collection.init.disable(
                ctx, auto_scaling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.metric_collection.init.disable auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="disable_metrics_collection",
        op_kwargs={"AutoScalingGroupName": auto_scaling_group_name, "Metrics": metrics},
    )


async def enable(
    hub, ctx, auto_scaling_group_name: str, granularity: str, metrics: List = None
) -> None:
    r"""
    **Autogenerated function**

    Enables group metrics for the specified Auto Scaling group. For more information, see Monitoring CloudWatch metrics for your Auto Scaling groups and instances in the Amazon EC2 Auto Scaling User Guide.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        metrics(List, optional): Specifies which group-level metrics to start collecting. You can specify one or more of the following metrics:    GroupMinSize     GroupMaxSize     GroupDesiredCapacity     GroupInServiceInstances     GroupPendingInstances     GroupStandbyInstances     GroupTerminatingInstances     GroupTotalInstances    The instance weighting feature supports the following additional metrics:     GroupInServiceCapacity     GroupPendingCapacity     GroupStandbyCapacity     GroupTerminatingCapacity     GroupTotalCapacity    The warm pools feature supports the following additional metrics:     WarmPoolDesiredCapacity     WarmPoolWarmedCapacity     WarmPoolPendingCapacity     WarmPoolTerminatingCapacity     WarmPoolTotalCapacity     GroupAndWarmPoolDesiredCapacity     GroupAndWarmPoolTotalCapacity    If you omit this parameter, all metrics are enabled. . Defaults to None.
        granularity(str): The granularity to associate with the metrics to collect. The only valid value is 1Minute.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.metric_collection.init.enable(
                ctx, auto_scaling_group_name=value, granularity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.metric_collection.init.enable auto_scaling_group_name=value, granularity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="enable_metrics_collection",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "Metrics": metrics,
            "Granularity": granularity,
        },
    )
