"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(
    hub, ctx, auto_scaling_group_name: str, target_group_ar_ns: List
) -> Dict:
    r"""
    **Autogenerated function**

    Attaches one or more target groups to the specified Auto Scaling group. This operation is used with the following load balancer types:     Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.     Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP.     Gateway Load Balancer - Operates at the network layer (layer 3).   To describe the target groups for an Auto Scaling group, call the DescribeLoadBalancerTargetGroups API. To detach the target group from the Auto Scaling group, call the DetachLoadBalancerTargetGroups API. For more information, see Elastic Load Balancing and Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        target_group_ar_ns(List): The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups. To get the ARN of a target group, use the Elastic Load Balancing DescribeTargetGroups API operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.load_balancer.target_group.attach(
                ctx, auto_scaling_group_name=value, target_group_ar_ns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.load_balancer.target_group.attach auto_scaling_group_name=value, target_group_ar_ns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="attach_load_balancer_target_groups",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "TargetGroupARNs": target_group_ar_ns,
        },
    )


async def describe_all(
    hub,
    ctx,
    auto_scaling_group_name: str,
    next_token: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the load balancer target groups for the specified Auto Scaling group. To determine the availability of registered instances, use the State element in the response. When you attach a target group to an Auto Scaling group, the initial State value is Adding. The state transitions to Added after all Auto Scaling instances are registered with the target group. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions to InService after at least one Auto Scaling instance passes the health check. When the target group is in the InService state, Amazon EC2 Auto Scaling can terminate and replace any instances that are reported as unhealthy. If no registered instances pass the health checks, the target group doesn't enter the InService state.  Target groups also have an InService state if you attach them in the CreateAutoScalingGroup API call. If your target group state is InService, but it is not working properly, check the scaling activities by calling DescribeScalingActivities and take any corrective actions necessary. For help with failed health checks, see Troubleshooting Amazon EC2 Auto Scaling: Health checks in the Amazon EC2 Auto Scaling User Guide. For more information, see Elastic Load Balancing and Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_records(int, optional): The maximum number of items to return with this call. The default value is 100 and the maximum value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.load_balancer.target_group.describe_all(
                ctx, auto_scaling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.load_balancer.target_group.describe_all auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_load_balancer_target_groups",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "NextToken": next_token,
            "MaxRecords": max_records,
        },
    )


async def detach(
    hub, ctx, auto_scaling_group_name: str, target_group_ar_ns: List
) -> Dict:
    r"""
    **Autogenerated function**

    Detaches one or more target groups from the specified Auto Scaling group.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        target_group_ar_ns(List): The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.load_balancer.target_group.detach(
                ctx, auto_scaling_group_name=value, target_group_ar_ns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.load_balancer.target_group.detach auto_scaling_group_name=value, target_group_ar_ns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="detach_load_balancer_target_groups",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "TargetGroupARNs": target_group_ar_ns,
        },
    )
