"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, lifecycle_hook_name: str, auto_scaling_group_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified lifecycle hook. If there are any outstanding lifecycle actions, they are completed first (ABANDON for launching instances, CONTINUE for terminating instances).

    Args:
        lifecycle_hook_name(str): The name of the lifecycle hook.
        auto_scaling_group_name(str): The name of the Auto Scaling group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.lifecycle.hook.init.delete(
                ctx, lifecycle_hook_name=value, auto_scaling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.lifecycle.hook.init.delete lifecycle_hook_name=value, auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="delete_lifecycle_hook",
        op_kwargs={
            "LifecycleHookName": lifecycle_hook_name,
            "AutoScalingGroupName": auto_scaling_group_name,
        },
    )


async def describe_all(
    hub, ctx, auto_scaling_group_name: str, lifecycle_hook_names: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the lifecycle hooks for the specified Auto Scaling group.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        lifecycle_hook_names(List, optional): The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.lifecycle.hook.init.describe_all(
                ctx, auto_scaling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.lifecycle.hook.init.describe_all auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_lifecycle_hooks",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "LifecycleHookNames": lifecycle_hook_names,
        },
    )


async def put(
    hub,
    ctx,
    lifecycle_hook_name: str,
    auto_scaling_group_name: str,
    lifecycle_transition: str = None,
    role_arn: str = None,
    notification_target_arn: str = None,
    notification_metadata: str = None,
    heartbeat_timeout: int = None,
    default_result: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a lifecycle hook for the specified Auto Scaling group. A lifecycle hook tells Amazon EC2 Auto Scaling to perform an action on an instance when the instance launches (before it is put into service) or as the instance terminates (before it is fully terminated). This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:   (Optional) Create a Lambda function and a rule that allows CloudWatch Events to invoke your Lambda function when Amazon EC2 Auto Scaling launches or terminates instances.   (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.    Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.    If you need more time, record the lifecycle action heartbeat to keep the instance in a pending state using the RecordLifecycleActionHeartbeat API call.   If you finish before the timeout period ends, complete the lifecycle action using the CompleteLifecycleAction API call.   For more information, see Amazon EC2 Auto Scaling lifecycle hooks in the Amazon EC2 Auto Scaling User Guide. If you exceed your maximum limit of lifecycle hooks, which by default is 50 per Auto Scaling group, the call fails. You can view the lifecycle hooks for an Auto Scaling group using the DescribeLifecycleHooks API call. If you are no longer using a lifecycle hook, you can delete it by calling the DeleteLifecycleHook API.

    Args:
        lifecycle_hook_name(str): The name of the lifecycle hook.
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        lifecycle_transition(str, optional): The instance state to which you want to attach the lifecycle hook. The valid values are:   autoscaling:EC2_INSTANCE_LAUNCHING   autoscaling:EC2_INSTANCE_TERMINATING   Required for new lifecycle hooks, but optional when updating existing hooks. Defaults to None.
        role_arn(str, optional): The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target, for example, an Amazon SNS topic or an Amazon SQS queue. Required for new lifecycle hooks, but optional when updating existing hooks. Defaults to None.
        notification_target_arn(str, optional): The ARN of the notification target that Amazon EC2 Auto Scaling uses to notify you when an instance is in the transition state for the lifecycle hook. This target can be either an SQS queue or an SNS topic. If you specify an empty string, this overrides the current ARN. This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key-value pair format when sending notifications to an Amazon SNS topic. When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages contain the following additional key-value pair: "Event": "autoscaling:TEST_NOTIFICATION". Defaults to None.
        notification_metadata(str, optional): Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target. Defaults to None.
        heartbeat_timeout(int, optional): The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from 30 to 7200 seconds. The default value is 3600 seconds (1 hour). If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the DefaultResult parameter. You can prevent the lifecycle hook from timing out by calling the RecordLifecycleActionHeartbeat API. Defaults to None.
        default_result(str, optional): Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. This parameter can be either CONTINUE or ABANDON. The default value is ABANDON. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.lifecycle.hook.init.put(
                ctx, lifecycle_hook_name=value, auto_scaling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.lifecycle.hook.init.put lifecycle_hook_name=value, auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="put_lifecycle_hook",
        op_kwargs={
            "LifecycleHookName": lifecycle_hook_name,
            "AutoScalingGroupName": auto_scaling_group_name,
            "LifecycleTransition": lifecycle_transition,
            "RoleARN": role_arn,
            "NotificationTargetARN": notification_target_arn,
            "NotificationMetadata": notification_metadata,
            "HeartbeatTimeout": heartbeat_timeout,
            "DefaultResult": default_result,
        },
    )
