"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def complete(
    hub,
    ctx,
    lifecycle_hook_name: str,
    auto_scaling_group_name: str,
    lifecycle_action_result: str,
    lifecycle_action_token: str = None,
    instance_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Completes the lifecycle action for the specified token or instance with the specified result. This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:   (Optional) Create a Lambda function and a rule that allows CloudWatch Events to invoke your Lambda function when Amazon EC2 Auto Scaling launches or terminates instances.   (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.   Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.   If you need more time, record the lifecycle action heartbeat to keep the instance in a pending state.    If you finish before the timeout period ends, complete the lifecycle action.    For more information, see Amazon EC2 Auto Scaling lifecycle hooks in the Amazon EC2 Auto Scaling User Guide.

    Args:
        lifecycle_hook_name(str): The name of the lifecycle hook.
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        lifecycle_action_token(str, optional): A universally unique identifier (UUID) that identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling sends this token to the notification target you specified when you created the lifecycle hook. Defaults to None.
        lifecycle_action_result(str): The action for the group to take. This parameter can be either CONTINUE or ABANDON.
        instance_id(str, optional): The ID of the instance. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.lifecycle.action.init.complete(
                ctx,
                lifecycle_hook_name=value,
                auto_scaling_group_name=value,
                lifecycle_action_result=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.lifecycle.action.init.complete lifecycle_hook_name=value, auto_scaling_group_name=value, lifecycle_action_result=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="complete_lifecycle_action",
        op_kwargs={
            "LifecycleHookName": lifecycle_hook_name,
            "AutoScalingGroupName": auto_scaling_group_name,
            "LifecycleActionToken": lifecycle_action_token,
            "LifecycleActionResult": lifecycle_action_result,
            "InstanceId": instance_id,
        },
    )
