"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    launch_configuration_name: str,
    image_id: str = None,
    key_name: str = None,
    security_groups: List = None,
    classic_link_vpc_id: str = None,
    classic_link_vpc_security_groups: List = None,
    user_data: str = None,
    instance_id: str = None,
    instance_type: str = None,
    kernel_id: str = None,
    ramdisk_id: str = None,
    block_device_mappings: List = None,
    instance_monitoring: Dict = None,
    spot_price: str = None,
    iam_instance_profile: str = None,
    ebs_optimized: bool = None,
    associate_public_ip_address: bool = None,
    placement_tenancy: str = None,
    metadata_options: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Creates a launch configuration. If you exceed your maximum limit of launch configurations, the call fails. To query this limit, call the DescribeAccountLimits API. For information about updating this limit, see Amazon EC2 Auto Scaling service quotas in the Amazon EC2 Auto Scaling User Guide. For more information, see Launch configurations in the Amazon EC2 Auto Scaling User Guide.

    Args:
        launch_configuration_name(str): The name of the launch configuration. This name must be unique per Region per account.
        image_id(str, optional): The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information, see Finding an AMI in the Amazon EC2 User Guide for Linux Instances. If you do not specify InstanceId, you must specify ImageId. Defaults to None.
        key_name(str, optional): The name of the key pair. For more information, see Amazon EC2 Key Pairs in the Amazon EC2 User Guide for Linux Instances. Defaults to None.
        security_groups(List, optional): A list that contains the security groups to assign to the instances in the Auto Scaling group. [EC2-VPC] Specify the security group IDs. For more information, see Security Groups for Your VPC in the Amazon Virtual Private Cloud User Guide. [EC2-Classic] Specify either the security group names or the security group IDs. For more information, see Amazon EC2 Security Groups in the Amazon EC2 User Guide for Linux Instances. Defaults to None.
        classic_link_vpc_id(str, optional): The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more information, see ClassicLink in the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic instances to a VPC in the Amazon EC2 Auto Scaling User Guide. This parameter can only be used if you are launching EC2-Classic instances. Defaults to None.
        classic_link_vpc_security_groups(List, optional): The IDs of one or more security groups for the specified ClassicLink-enabled VPC. For more information, see ClassicLink in the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic instances to a VPC in the Amazon EC2 Auto Scaling User Guide. If you specify the ClassicLinkVPCId parameter, you must specify this parameter. Defaults to None.
        user_data(str, optional): The user data to make available to the launched EC2 instances. For more information, see Instance metadata and user data (Linux) and Instance metadata and user data (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB. Defaults to None.
        instance_id(str, optional): The ID of the instance to use to create the launch configuration. The new launch configuration derives attributes from the instance, except for the block device mapping. To create a launch configuration with a block device mapping or override any other instance attributes, specify them as part of the same request. For more information, see Creating a launch configuration using an EC2 instance in the Amazon EC2 Auto Scaling User Guide. If you do not specify InstanceId, you must specify both ImageId and InstanceType. Defaults to None.
        instance_type(str, optional): Specifies the instance type of the EC2 instance. For information about available instance types, see Available Instance Types in the Amazon EC2 User Guide for Linux Instances. If you do not specify InstanceId, you must specify InstanceType. Defaults to None.
        kernel_id(str, optional): The ID of the kernel associated with the AMI. Defaults to None.
        ramdisk_id(str, optional): The ID of the RAM disk to select. Defaults to None.
        block_device_mappings(List, optional): A block device mapping, which specifies the block devices for the instance. You can specify virtual devices and EBS volumes. For more information, see Block Device Mapping in the Amazon EC2 User Guide for Linux Instances. Defaults to None.
        instance_monitoring(Dict, optional): Controls whether instances in this group are launched with detailed (true) or basic (false) monitoring. The default value is true (enabled).  When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see Configure Monitoring for Auto Scaling Instances in the Amazon EC2 Auto Scaling User Guide. . Defaults to None.
        spot_price(str, optional): The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see Requesting Spot Instances in the Amazon EC2 Auto Scaling User Guide.  When you change your maximum price by creating a new launch configuration, running instances will continue to run as long as the maximum price for those running instances is higher than the current Spot price. . Defaults to None.
        iam_instance_profile(str, optional): The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role. For more information, see IAM role for applications that run on Amazon EC2 instances in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        ebs_optimized(bool, optional): Specifies whether the launch configuration is optimized for EBS I/O (true) or not (false). The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For more information, see Amazon EBS-Optimized Instances in the Amazon EC2 User Guide for Linux Instances. The default value is false. Defaults to None.
        associate_public_ip_address(bool, optional): For Auto Scaling groups that are running in a virtual private cloud (VPC), specifies whether to assign a public IP address to the group's instances. If you specify true, each instance in the Auto Scaling group receives a unique public IP address. For more information, see Launching Auto Scaling instances in a VPC in the Amazon EC2 Auto Scaling User Guide. If you specify this parameter, you must specify at least one subnet for VPCZoneIdentifier when you create your group.  If the instance is launched into a default subnet, the default is to assign a public IP address, unless you disabled the option to assign a public IP address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IP address, unless you enabled the option to assign a public IP address on the subnet. . Defaults to None.
        placement_tenancy(str, optional): The tenancy of the instance. An instance with dedicated tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC. To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute set to default), you must set the value of this parameter to dedicated. If you specify PlacementTenancy, you must specify at least one subnet for VPCZoneIdentifier when you create your group. For more information, see Configuring instance tenancy with Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide. Valid Values: default | dedicated . Defaults to None.
        metadata_options(Dict, optional): The metadata options for the instances. For more information, see Configuring the Instance Metadata Options in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.launch_configuration.create(
                ctx, launch_configuration_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.launch_configuration.create launch_configuration_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="create_launch_configuration",
        op_kwargs={
            "LaunchConfigurationName": launch_configuration_name,
            "ImageId": image_id,
            "KeyName": key_name,
            "SecurityGroups": security_groups,
            "ClassicLinkVPCId": classic_link_vpc_id,
            "ClassicLinkVPCSecurityGroups": classic_link_vpc_security_groups,
            "UserData": user_data,
            "InstanceId": instance_id,
            "InstanceType": instance_type,
            "KernelId": kernel_id,
            "RamdiskId": ramdisk_id,
            "BlockDeviceMappings": block_device_mappings,
            "InstanceMonitoring": instance_monitoring,
            "SpotPrice": spot_price,
            "IamInstanceProfile": iam_instance_profile,
            "EbsOptimized": ebs_optimized,
            "AssociatePublicIpAddress": associate_public_ip_address,
            "PlacementTenancy": placement_tenancy,
            "MetadataOptions": metadata_options,
        },
    )


async def delete(hub, ctx, launch_configuration_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified launch configuration. The launch configuration must not be attached to an Auto Scaling group. When this call completes, the launch configuration is no longer available for use.

    Args:
        launch_configuration_name(str): The name of the launch configuration.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.launch_configuration.delete(
                ctx, launch_configuration_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.launch_configuration.delete launch_configuration_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="delete_launch_configuration",
        op_kwargs={"LaunchConfigurationName": launch_configuration_name},
    )


async def describe_all(
    hub,
    ctx,
    launch_configuration_names: List = None,
    next_token: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the launch configurations in the account and Region.

    Args:
        launch_configuration_names(List, optional): The launch configuration names. If you omit this parameter, all launch configurations are described. Array Members: Maximum number of 50 items. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_records(int, optional): The maximum number of items to return with this call. The default value is 50 and the maximum value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.launch_configuration.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.launch_configuration.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_launch_configurations",
        op_kwargs={
            "LaunchConfigurationNames": launch_configuration_names,
            "NextToken": next_token,
            "MaxRecords": max_records,
        },
    )
