"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"set_": "set"}


async def set_(
    hub,
    ctx,
    instance_ids: List,
    auto_scaling_group_name: str,
    protected_from_scale_in: bool,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the instance protection settings of the specified instances. This operation cannot be called on instances in a warm pool. For more information about preventing instances that are part of an Auto Scaling group from terminating on scale in, see Instance scale-in protection in the Amazon EC2 Auto Scaling User Guide. If you exceed your maximum limit of instance IDs, which is 50 per Auto Scaling group, the call fails.

    Args:
        instance_ids(List): One or more instance IDs. You can specify up to 50 instances.
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        protected_from_scale_in(bool): Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.instance.protection.set(
                ctx,
                instance_ids=value,
                auto_scaling_group_name=value,
                protected_from_scale_in=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.instance.protection.set instance_ids=value, auto_scaling_group_name=value, protected_from_scale_in=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="set_instance_protection",
        op_kwargs={
            "InstanceIds": instance_ids,
            "AutoScalingGroupName": auto_scaling_group_name,
            "ProtectedFromScaleIn": protected_from_scale_in,
        },
    )
