"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(
    hub, ctx, auto_scaling_group_name: str, instance_ids: List = None
) -> None:
    r"""
    **Autogenerated function**

    Attaches one or more EC2 instances to the specified Auto Scaling group. When you attach instances, Amazon EC2 Auto Scaling increases the desired capacity of the group by the number of instances being attached. If the number of instances being attached plus the desired capacity of the group exceeds the maximum size of the group, the operation fails. If there is a Classic Load Balancer attached to your Auto Scaling group, the instances are also registered with the load balancer. If there are target groups attached to your Auto Scaling group, the instances are also registered with the target groups. For more information, see Attach EC2 instances to your Auto Scaling group in the Amazon EC2 Auto Scaling User Guide.

    Args:
        instance_ids(List, optional): The IDs of the instances. You can specify up to 20 instances. Defaults to None.
        auto_scaling_group_name(str): The name of the Auto Scaling group.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.instance.init.attach(
                ctx, auto_scaling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.instance.init.attach auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="attach_instances",
        op_kwargs={
            "InstanceIds": instance_ids,
            "AutoScalingGroupName": auto_scaling_group_name,
        },
    )


async def detach(
    hub,
    ctx,
    auto_scaling_group_name: str,
    should_decrement_desired_capacity: bool,
    instance_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes one or more instances from the specified Auto Scaling group. After the instances are detached, you can manage them independent of the Auto Scaling group. If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to replace the ones that are detached. If there is a Classic Load Balancer attached to the Auto Scaling group, the instances are deregistered from the load balancer. If there are target groups attached to the Auto Scaling group, the instances are deregistered from the target groups. For more information, see Detach EC2 instances from your Auto Scaling group in the Amazon EC2 Auto Scaling User Guide.

    Args:
        instance_ids(List, optional): The IDs of the instances. You can specify up to 20 instances. Defaults to None.
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        should_decrement_desired_capacity(bool): Indicates whether the Auto Scaling group decrements the desired capacity value by the number of instances detached.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.instance.init.detach(
                ctx, auto_scaling_group_name=value, should_decrement_desired_capacity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.instance.init.detach auto_scaling_group_name=value, should_decrement_desired_capacity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="detach_instances",
        op_kwargs={
            "InstanceIds": instance_ids,
            "AutoScalingGroupName": auto_scaling_group_name,
            "ShouldDecrementDesiredCapacity": should_decrement_desired_capacity,
        },
    )
