"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def terminate(
    hub, ctx, instance_id: str, should_decrement_desired_capacity: bool
) -> Dict:
    r"""
    **Autogenerated function**

    Terminates the specified instance and optionally adjusts the desired group size. This operation cannot be called on instances in a warm pool. This call simply makes a termination request. The instance is not terminated immediately. When an instance is terminated, the instance status changes to terminated. You can't connect to or start an instance after you've terminated it. If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to replace the ones that are terminated.  By default, Amazon EC2 Auto Scaling balances instances across all Availability Zones. If you decrement the desired capacity, your Auto Scaling group can become unbalanced between Availability Zones. Amazon EC2 Auto Scaling tries to rebalance the group, and rebalancing might terminate instances in other zones. For more information, see Rebalancing activities in the Amazon EC2 Auto Scaling User Guide.

    Args:
        instance_id(str): The ID of the instance.
        should_decrement_desired_capacity(bool): Indicates whether terminating the instance also decrements the size of the Auto Scaling group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.instance.in_auto_scaling_group.terminate(
                ctx, instance_id=value, should_decrement_desired_capacity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.instance.in_auto_scaling_group.terminate instance_id=value, should_decrement_desired_capacity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="terminate_instance_in_auto_scaling_group",
        op_kwargs={
            "InstanceId": instance_id,
            "ShouldDecrementDesiredCapacity": should_decrement_desired_capacity,
        },
    )
