"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


__func_alias__ = {"set_": "set"}


async def set_(
    hub,
    ctx,
    instance_id: str,
    health_status: str,
    should_respect_grace_period: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Sets the health status of the specified instance. For more information, see Health checks for Auto Scaling instances in the Amazon EC2 Auto Scaling User Guide.

    Args:
        instance_id(str): The ID of the instance.
        health_status(str): The health status of the instance. Set to Healthy to have the instance remain in service. Set to Unhealthy to have the instance be out of service. Amazon EC2 Auto Scaling terminates and replaces the unhealthy instance.
        should_respect_grace_period(bool, optional): If the Auto Scaling group of the specified instance has a HealthCheckGracePeriod specified for the group, by default, this call respects the grace period. Set this to False, to have the call not respect the grace period associated with the group. For more information about the health check grace period, see CreateAutoScalingGroup in the Amazon EC2 Auto Scaling API Reference. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.instance.health.set(
                ctx, instance_id=value, health_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.instance.health.set instance_id=value, health_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="set_instance_health",
        op_kwargs={
            "InstanceId": instance_id,
            "HealthStatus": health_status,
            "ShouldRespectGracePeriod": should_respect_grace_period,
        },
    )
