"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


__func_alias__ = {"set_": "set"}


async def set_(
    hub,
    ctx,
    auto_scaling_group_name: str,
    desired_capacity: int,
    honor_cooldown: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Sets the size of the specified Auto Scaling group. If a scale-in activity occurs as a result of a new DesiredCapacity value that is lower than the current size of the group, the Auto Scaling group uses its termination policy to determine which instances to terminate.  For more information, see Manual scaling in the Amazon EC2 Auto Scaling User Guide.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        desired_capacity(int): The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain.
        honor_cooldown(bool, optional): Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before initiating a scaling activity to set your Auto Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling does not honor the cooldown period during manual scaling activities. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.desired_capacity.set(
                ctx, auto_scaling_group_name=value, desired_capacity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.desired_capacity.set auto_scaling_group_name=value, desired_capacity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="set_desired_capacity",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "DesiredCapacity": desired_capacity,
            "HonorCooldown": honor_cooldown,
        },
    )
