"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, auto_scaling_group_name: str, scheduled_action_names: List
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more scheduled actions for the specified Auto Scaling group.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        scheduled_action_names(List): The names of the scheduled actions to delete. The maximum number allowed is 50. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.delete_scheduled_action.batch(
                ctx, auto_scaling_group_name=value, scheduled_action_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.delete_scheduled_action.batch auto_scaling_group_name=value, scheduled_action_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="batch_delete_scheduled_action",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "ScheduledActionNames": scheduled_action_names,
        },
    )
